// bergmark - Spring 1999 - ITX project

// PBXSignalDelete is a simple utility to run if PBXSignalingServer
// crashed without unregistering with Directory Service
// It unregisters ALL current locations in the database, except for Roaming.

// To run:   
// Unix:  java PBXSignalDelete 
// NT:    jview cnrg.itx.gtwy.pbx.PBXSignalDelete 

package cnrg.itx.gtwy.pbx;

import cnrg.itx.ds.*;

public class PBXSignalDelete {

   public static void main ( String[] args ) {

      PBXSignalDelete t = new PBXSignalDelete();

   }

   public PBXSignalDelete () {

      int myPort;                   // String version 
      LocationList myLocs = null;   // Addresses and ports on which we are
      Location thisLoc = null;
      DirectoryService myDirS = null;

      // get the Directory Server
      myDirS = getDirectoryService();

      // get all the Locations where PBXsrv is currently registerd
      try {
         myLocs = myDirS.getLocationListByID (new UserID ("pbxsrv"));
      } catch (AccessDeniedException e) {System.out.println (e); 
      } catch (RecordNotFoundException e) {System.out.println (e);
      } catch (AuthenticationException e) {System.out.println (e);
      }


      if ( myLocs != null ) thisLoc = myLocs.first();
      while ( thisLoc != null ) {

            try {
	       myDirS.unregisterLocation(Location.DYNAMIC, thisLoc);
            } catch ( DirectoryServiceException e) {
	       System.out.println (" Could not unregister dynamic");
               System.out.println ("PBXSignalDelete not deleting the "
                 + "Roaming location");
            }

         thisLoc = myLocs.next();

      }

   } // ends main

   private DirectoryService getDirectoryService () {
       DirectoryService d = null;
       UserID myUID = new UserID ("pbxsrv");
       Password myPIN = new Password ("itxpbx");
       try {
	  d = new DirectoryService ();
       } catch ( Exception e ) {
            e.printStackTrace();
            System.out.println("PBXSignalDelete "+"Exiting...No Directory Service");
            System.exit(0);
       }

       System.out.println ( "PBXSignalDelete " + "got a DirectoryService");
       try { d.declareIdentity ( myUID, myPIN );
       } catch ( AuthenticationException e )
          { System.out.println("PBXSignalDelete " + e); }

       return d;
   }

}


